<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CWidgetsWidgetMMediaCards extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "16",
		"name"	=> "Media Cards w/ Flip",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		$items = $this->module->GetStaticItems($widget);

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {

			//preprocess body when i dont have the html editor

			$btns = $this->module->WidgetButtons(
				array( 
					"settings"	=> array(
						"lang_link_type"	=> $val["item_link_type"],
						"lang_link_link"	=> $val["item_link_link"],
						"lang_link_module"	=> $val["item_link_module"],
						"lang_link_global"	=> $val["item_link_global"],
						"lang_link_text"	=> $val["item_link_text"],
						"lang_link_size"	=> $val["item_link_size"],
						"lang_link_target"	=> $val["item_link_target"],
						"lang_link_style"	=> $val["item_link_style"],
						"lang_link_rel"		=> $val["item_link_rel"],

						"lang_link2_type"	=> $val["item_link2_type"],
						"lang_link2_link"	=> $val["item_link2_link"],
						"lang_link2_module"	=> $val["item_link2_module"],
						"lang_link2_global"	=> $val["item_link2_global"],
						"lang_link2_text"	=> $val["item_link2_text"],
						"lang_link2_size"	=> $val["item_link2_size"],
						"lang_link2_target"	=> $val["item_link2_target"],
						"lang_link2_style"	=> $val["item_link2_style"],
						"lang_link2_rel"	=> $val["item_link2_rel"],
					)
				), 
				$this->tpl,
				"Link"
			);

			$items[$key]["btn1"] = $btns["btn1"];
			$items[$key]["btn2"] = $btns["btn2"];

			$items[$key]["title"]	= $val["item_title"] ? $this->tpl->blockreplace("Title" , $val ) : "";
			$items[$key]["body"]	= $val["item_desc"] ? $this->tpl->blockreplace("Body" , $val , array("BG:SCHEME" => "{NORMAL_BG:SCHEME}")) : "";

			switch ($val["item_type"]) {
				case "1": $items[$key]["resource"] = $this->tpl->blockReplace("Image" , $val); break;
				case "2": $items[$key]["resource"] = $this->tpl->blockReplace("Youtube" , $val); break;
				case "3": $items[$key]["resource"] = $this->tpl->blockReplace("Vimeo" , $val); break;
				case "4": $items[$key]["resource"] = $this->tpl->blockReplace("Icon" , $val); break;
				case "5": $items[$key]["resource"] = $this->tpl->blockReplace("HTML" , $val); break;
				default: $items[$key]["resource"] = ""; break;
			}			
	
			$items[$key]["normal_bg:scheme"] = "{BG:SCHEME}";

			if ($val["item_bg"]) {
				$bg = $this->plugins["backgrounds"]->GetBg($val["item_bg"]);

				if ($bg["bg:scheme"]) {
					$items[$key]["normal_bg:scheme"] = $bg["bg:scheme"];
				}				

				$items[$key]["bg_class"] = $val["bg_class"] = $bg["class"];
				$items[$key]["bg_html"] = $val["bg_html"] = $bg["html"];
			} else {
				$items[$key]["bg_class"] = $val["bg_class"] = "";
				$items[$key]["bg_html"] = $val["bg_html"] = "";
			}
			

			if ($val["item_flip"]) {

				$items[$key]["flip_icon"] = $this->tpl->blockReplace("FlipIcon");
				$items[$key]["flip_bg:scheme"] = "{BG:SCHEME}";

				$bg_flip = array();

				if ($val["item_bg_flip"]) {
					$bg_flip = $this->plugins["backgrounds"]->GetBg($val["item_bg_flip"]);

					$items[$key]["flip_bg_class"] = $val["flip_bg_class"] = $bg_flip["class"];
					$items[$key]["flip_bg_html"] = $val["flip_bg_html"] = $bg_flip["html"];

					if ($bg_flip["bg:scheme"]) {
						$items[$key]["flip_bg:scheme"] = $bg_flip["bg:scheme"];
					}

				} else {
					$items[$key]["flip_bg_class"] = $val["flip_bg_class"] = "";
					$items[$key]["flip_bg_html"] = $val["flip_bg_html"] = "";
				}


				$btns = $this->module->WidgetButtons(
					array( 
						"settings"	=> array(
							"lang_link_type"	=> $val["item_flip_link_type"],
							"lang_link_link"	=> $val["item_flip_link_link"],
							"lang_link_module"	=> $val["item_flip_link_module"],
							"lang_link_global"	=> $val["item_flip_link_global"],
							"lang_link_text"	=> $val["item_flip_link_text"],
							"lang_link_size"	=> $val["item_flip_link_size"],
							"lang_link_target"	=> $val["item_flip_link_target"],
							"lang_link_style"	=> $val["item_flip_link_style"],
							"lang_link_rel"		=> $val["item_flip_link_rel"],

							"lang_link2_type"	=> $val["item_flip_link2_type"],
							"lang_link2_link"	=> $val["item_flip_link2_link"],
							"lang_link2_module"	=> $val["item_flip_link2_module"],
							"lang_link2_global"	=> $val["item_flip_link2_global"],
							"lang_link2_text"	=> $val["item_flip_link2_text"],
							"lang_link2_size"	=> $val["item_flip_link2_size"],
							"lang_link2_target"	=> $val["item_flip_link2_target"],
							"lang_link2_style"	=> $val["item_flip_link2_style"],
							"lang_link2_rel"	=> $val["item_flip_link2_rel"],
						)
					), 
					$this->tpl,
					"Link"
				);

				$items[$key]["flip_btn1"] = $btns["btn1"];
				$items[$key]["flip_btn2"] = $btns["btn2"];


				$items[$key]["flip_title"]	= $val["item_flip_title"] ? $this->tpl->blockreplace("Title" , array("item_title" => $val["item_flip_title"]) ) : "";
				$items[$key]["flip_body"]	= $val["item_flip_desc"] ? $this->tpl->blockreplace("Body" , array(
					"bg:scheme" => $bg_flip["bg:scheme"] ? $bg_flip["bg:scheme"] : "{BG:SCHEME}" , 
					"item_desc" => $val["item_flip_desc"]) ) : "";

				switch ($val["item_flip_type"]) {
					case "1": $items[$key]["flip_resource"] = $this->tpl->blockReplace("Image" , array("item_id" => "b_" . $val["item_id"])); break;
					case "2": $items[$key]["flip_resource"] = $this->tpl->blockReplace("Youtube" , array("item_youtube" => $val["item_flip_youtube"])); break;
					case "3": $items[$key]["flip_resource"] = $this->tpl->blockReplace("Vimeo" , array("item_vimeo" => $val["item_flip_vimeo"])); break;
					case "4": $items[$key]["flip_resource"] = $this->tpl->blockReplace("Icon" , array("item_icon" => $val["item_flip_icon"])); break;
					case "5": $items[$key]["flip_resource"] = $this->tpl->blockReplace("HTML" , array("item_html" => $val["item_flip_html"])); break;
					default: $items[$key]["flip_resource"] = ""; break;
				}			


				$items[$key]["flip"] = $this->tpl->blockReplace("Flip" , $items[$key]);

				$items[$key]["flip_class"] = $this->tpl->blockReplace("FlipClass");

			} else {
				$items[$key]["flip"] = $items[$key]["flip_class"] = $items[$key]["flip_icon"] = "";
			}
			

			//process the custom width
			if ($val["item_size"]) {
				$items[$key]["set_size"] = $val["item_size"];
				$items[$key]["set_size_lg"] = $val["item_size_lg"];
				$items[$key]["set_size_md"] = $val["item_size_md"];
				$items[$key]["set_size_sm"] = $val["item_size_sm"];
				$items[$key]["set_size_xs"] = $val["item_size_xs"];
			}					
		}		

		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->Table(
					$this->tpl , 
					"" , 
					$items
				),
				"isotope"	=> $this->tpl->BlockReplace($widget["settings"]["set_height"] ? "StaticHeight" : "AutoHeight" ),
			),
			$widget["settings"],
			$widget
		);	

	}
			

}


?>